unit DOSlin;

interface

uses
  DOS, Crt;

const
  ProgName      = 'DOSuX';
  ProgVersion   = 'V 0.06';

var
  LinPath       : string;
  path          : string;
  command       : string;



procedure Lin2dosFn(var s : string); { Converts Linux FN to DOS }
procedure Dos2linFn(var s : string); { Converts DOS FN to Linux }

function LinuxFN(orig : string) : string;
function DosFN(orig : string) : string;


implementation

procedure Lin2dosFn(var s : string); { Converts Linux FN to DOS }
var
  x             : byte;
begin
  for x:=1 to length(s) do case s[x] of
    '/'      : s[x]:='\';
    {'a'..'z' : s[x]:=char(byte(s[x])-32);}
  end;
end;

procedure Dos2linFn(var s : string); { Converts DOS FN to Linux }
var
  x             : byte;
begin
  for x:=1 to length(s) do case s[x] of
    '\'      : s[x]:='/';
    'A'..'Z' : s[x]:=char(byte(s[x])+32);
  end;
end;


function LinuxFN;
begin
  Dos2LinFN(orig);
  LinuxFN:=orig;
end;

function DosFN;
begin
  Lin2DosFN(orig);
  DosFN:=orig;
end;

end.