{$DEFINE debug}
{$M 10000,0,10000}
program LinDos;

uses
  Crt, DOS, Georg, Objects, DOSlin, List;


var
  History       : array[1..255] of PString;
  HistCnt       : byte;
  Aliases       : array[1..255, 0..1] of PString;
  AliasCnt      : byte;

  TabUsed       : boolean;
  srchpath      : string;
  sucher        : SearchRec;




function GetCmdLine : string;
var
  curspos       : byte;
  ch            : char;
  s, prompt, vol: string;
  x, y          : byte;

  procedure WritePrompt;
  begin
    TextColor(11);
    write(prompt);
    TextColor(7);
  end;

  procedure CompleteCmd(var entered : string);
  var
    iscmd, isdir  : boolean;
    before, after,
    main, mpath,
    mknown        : string;
    spacepos      : byte;
    such          : string;
    found         : boolean;

    procedure FindeAlle;
    var
      cnt         : word;
      s           : string;

      procedure Gefunden;
      var
        n         : string;
        i         : byte;
        out       : string;
      begin
        { passende Datei gefunden }
        with Sucher do begin
          n:=name;
          inc(cnt);
          if TabUsed then begin
            if cnt=1 then writeln;
            out:=LinuxFN(N);
            out:=writeName(out, 0, Attr and Directory<>0);
            while length(out)<16 do begin
              write(' ');
              out:=out+' ';
            end;
          end;
          if s='' then s:=N else
          if N[0]>s[0] then s[0]:=N[0];
          for i:=byte(s[0]) downto 1 do
            if s[i]<>N[i] then s[0]:=char(i-1);
          if (s=n) and (cnt=1) and (Sucher.Attr and Directory<>0) then
            s:=s+'/';
        end;
      end;

    begin
      cnt:=0;
      s:='';
      if pos('.', mknown)<>0 then such:='*' else such:='*.*';
      FindFirst(mpath+mknown+such, AnyFile, Sucher);
      {while (DOSerror=0) and (Sucher.Name[1]='.') do FindNext(Sucher);}
      if (DOSerror<>0) and ((mknown='.') or (mknown='..')) then mknown:=mknown+'/';
      while (DOSerror=0) do with Sucher do begin
        if iscmd and ((Attr and Directory<>0) or (pos('.EXE', name)<>0) or
             (pos('.COM', name)<>0) or (pos('.BAT', name)<>0)) then Gefunden;
        if not iscmd and isdir and (Attr and Directory<>0) then Gefunden;
        if not iscmd and not isdir then Gefunden;
        FindNext(Sucher);
      end;
      if tabused and (cnt<>0) then begin
        if (WhereX<>1) then writeln;
        writeprompt;
      end;
      if cnt>1 then begin
        write(#7);
        if mknown<>'' then
          mknown:=s;
      end else if cnt=1 then mknown:=s else write(#7);
    end;

  begin
    { Gltigkeitsbedingungen }
    if (curspos<length(entered)) and (entered[curspos]<>' ') then exit;
    { Aufspalten in unntige (before, after) und den ntigen Wert (main) }
    main:=copy(entered, 1, curspos);
    before:='';
    after:=copy(entered, curspos, 255);
    {if main[length(main)]=' ' then begin
      dec(byte(main[0]));
      after:=' '+after;
    end;}
    spacepos:=pos(' ', entered);
    while spacepos<>0 do begin
      before:=before+copy(main, 1, spacepos);
      delete(main, 1, spacepos);
      spacepos:=pos(' ', main);
    end;
    iscmd:=(before=''); { Wenn nix davorsteht, dann Befehl }
    isdir:=(pos('cd', before)<>0) or (pos('chdir', before)<>0) or
           (pos('rd', before)<>0) or (pos('rmdir', before)<>0);
    mpath:=main;
    mknown:='';
    while (mpath[0]>#0) and not (mpath[byte(mpath[0])] in ['\', '/', ':']) do begin
      mknown:=mpath[byte(mpath[0])]+mknown;
      dec(byte(mpath[0]));
    end;
    FindeAlle;
    entered:=before+mpath+mknown;
    curspos:=length(entered);
    entered:=entered+after;
  end;


var
  Hist          : byte;

begin
  Hist:=0;
  getDir(0, prompt);
  if prompt[2]=':' then begin
    chDir('\');
    FindFirst('*.*', VolumeID, Sucher);
    if DOSerror=0 then vol:='\'+Sucher.Name else vol:=prompt[1]+prompt[2];
    if vol[10]='.' then delete(vol, 10, 1);
    chDir(prompt);
    delete(prompt, 1, 2);
    prompt:=vol+prompt;
  end;
  prompt:=KleinStr(prompt);
  if prompt[byte(prompt[0])]<>'\' then prompt:=prompt+'\';
  prompt:=prompt+'# ';
  for x:=1 to length(prompt) do if prompt[x]='\' then prompt[x]:='/';
  if WhereX<>1 then writeln;
  writeln;
  writeprompt;
  ClrEol;
  x:=WhereX;
  y:=WhereY;
  s:='';
  curspos:=1;
  TabUsed:=false;
  repeat
    ch:=readkey;
    if ch<>#9 then TabUsed:=false;
    case ch of
      #0  : case readkey of
        #75 : if curspos>1 then dec(curspos);
        #77 : if curspos<=length(s) then inc(curspos);
        #72 : if histCnt<>0 then begin
          if Hist=0 then Hist:=HistCnt;
          s:=History[Hist]^;
          CursPos:=length(s)+1;
          dec(Hist);
        end;
        #80 : if histCnt<>0 then begin
          if Hist=0 then Hist:=1;
          s:=History[Hist]^;
          CursPos:=length(s)+1;
          inc(Hist);
          if Hist>HistCnt then Hist:=0;
        end;
      end;
      ^C  : s:='exit';
      ^D  : s:='logout';
      #8  : if curspos>1 then begin
        dec(curspos);
        delete(s, curspos, 1);
      end;
      #9  : begin
        CompleteCmd(s);
        curspos:=length(s)+1;
        TabUsed:=true;
      end;
      #13 : ;
      #27 : begin
        s:='';
        Curspos:=1;
      end;
      #0..#31 : ; { Sonderzeichen }
      else begin
        insert(ch, s, curspos);
        inc(curspos);
      end;
    end;
    GotoXY(x, WhereY);
    write(LinuxFN(s));
    ClrEol;
    GotoXY(x+curspos-1, WhereY);
  until (ch=#13) or (ch=^D) or (ch=^C);
  writeln;
  GetCmdLine:=s;
end;

procedure LoadHistory;
var
  f             : text;
  s             : string;
begin
  assign(f, LinPath+ProgName+'.hst');
  HistCnt:=0;
  {$I-}
  reset(f);
  {$I+}
  if IOresult=0 then begin
    while not eof(f) do begin
      readln(f, s);
      while s[1]=' ' do delete(s, 1, 1);
      if pos('#', s)<>0 then
        delete(s, pos('#', s), 255);
      while s[byte(s[0])]=' ' do dec(byte(s[0]));
      if s<>'' then begin
        inc(HistCnt);
        History[HistCnt]:=NewStr(s);
      end;
    end;
    close(f);
  end;
end;
procedure SaveHistory;
var
  f             : text;
  i             : byte;
begin
  assign(f, LinPath+ProgName+'.hst');
  rewrite(f);
  writeln(f, '# history file');
  writeln(f, '# generated by '+ProgName+' '+ProgVersion);
  for i:=1 to HistCnt do begin
    writeln(f, History[i]^);
    disposeStr(History[i]);
  end;
  HistCnt:=0;
  close(f);
end;


procedure Add2History(cmd : string);
var
  Hist          : byte;
begin
  if HistCnt=255 then begin
    disposeStr(History[1]);
    for Hist:=1 to 255 do History[Hist]:=History[Hist+1];
    History[255]:=NewStr(cmd);
  end else begin
    inc(HistCnt);
    History[HistCnt]:=NewStr(cmd);
  end;
end;



procedure LoadAliases;
var
  f             : text;
  s             : string;
begin
  assign(f, LinPath+ProgName+'.als');
  {$I-}
  reset(f);
  {$I+}
  if IOresult=0 then begin
    while not eof(f) do begin
      readln(f, s);
      while s[1]=' ' do delete(s, 1, 1);
      if pos('#', s)<>0 then
        delete(s, pos('#', s), 255);
      while s[byte(s[0])]=' ' do dec(byte(s[0]));
      if s<>'' then begin
        inc(AliasCnt);
        Aliases[AliasCnt, 0]:=NewStr(copy(s, 1, pos('=', s)-1));
        Aliases[AliasCnt, 1]:=NewStr(copy(s, pos('=', s)+1, 255));
      end;
    end;
    close(f);
  end;
end;
procedure SaveAliases;
var
  f             : text;
  i             : byte;
begin
  assign(f, LinPath+ProgName+'.als');
  rewrite(f);
  writeln(f, '# alias file');
  writeln(f, '# generated by '+ProgName+' '+ProgVersion);
  for i:=1 to AliasCnt do begin
    writeln(f, Aliases[i, 0]^, '=', Aliases[i, 1]^);
    disposeStr(Aliases[i, 0]);
    disposeStr(Aliases[i, 1]);
  end;
  AliasCnt:=0;
  close(f);
end;





var
  Stop          : boolean;

function PreProcessCmd(var cmd : string) : boolean;
var
  x             : byte;
  err           : integer;
begin
  Lin2dosFN(cmd);
  PreProcessCmd:=TRUE;
  while (cmd[1]=' ') and (cmd<>'') do delete(cmd, 1, 1);
  if cmd[1]='!' then begin
    val(copy(cmd, 2, 255), x, err);
    if err<>0 then cmd:=History[HistCnt]^ else cmd:=History[x]^;
  end else Add2History(cmd);
  for x:=1 to AliasCnt do if pos(Aliases[x, 0]^+' ', cmd+' ')=1 then begin
    delete(cmd, 1, length(Aliases[x, 0]^));
    cmd:=Aliases[x, 1]^+cmd;
  end;
  if pos('ls', cmd)=1 then ls(cmd) else
  if cmd='logout' then begin
    writeln('CU later');
    Stop:=TRUE;
  end else if pos('alias', cmd)=1 then begin
    for x:=1 to AliasCnt do writeln(Aliases[x, 0]^, '=', Aliases[x, 1]^);
  end else if pos('history', cmd)=1 then begin
    for x:=1 to HistCnt do writeln(x:3, ' ', History[x]^);
  end else
{$IFDEF debug}
  if cmd='debug' then begin
    writeln('Free Heap:    ', maxavail, ' Bytes');
    writeln('Path to exe:  ', LinPath);
    writeln('# of Aliases: ', AliasCnt);
  end else
{$ENDIF}
  PreProcessCmd:=FALSE;
end;


var
  StartDir      : string;
  input         : string;
  x             : byte;
begin
  GetDir(0, StartDir);
  LinPath:=FExpand(paramstr(0));
  for x:=length(LinPath) downto 1 do if LinPath[x]='\' then begin
    LinPath[0]:=char(x);
    break;
  end;
  command:=GetEnv('COMSPEC');
  path:=GetEnv('PATH');
  Stop:=FALSE;
  writeln;
  writeln(ProgName, ' ', ProgVersion);
  writeln('(C) Dez. 1997 Georg Lukas');
  writeln;
  LoadAliases;
  LoadHistory;
  LoadColors;
  repeat
    input:=GetCmdLine;
    if not PreProcessCmd(input) then begin
      SwapVectors;
      exec(command, '/C'+input);
      SwapVectors;
    end;
  until Stop;
  SaveAliases;
  SaveHistory;
  ChDir(StartDir);
end.
