{$DEFINE debug}
unit list;

interface


var
  FileCol       : array[1..255] of record
    Typ           : string[3];
    Color         : byte;
  end;
  FileColCnt    : byte;

procedure LoadColors;
{procedure SaveColors;}
function Color(name : string; isadir : boolean) : byte;
function WriteName(name : string; align : byte; isadir : boolean) : string;


procedure ls(cmdline : string);

implementation

uses
  Crt, DOS, DOSlin, Georg;


procedure LoadColors;
var
  f             : text;
  s             : string;
  err           : integer;
begin
  FileColCnt:=0;
  assign(f, LinPath+ProgName+'.col');
  {$I-}
  reset(f);
  {$I+}
  if IOresult=0 then begin
    while not eof(f) do begin
      readln(f, s);
      while s[1]=' ' do delete(s, 1, 1);
      if pos('#', s)<>0 then
        delete(s, pos('#', s), 255);
      while s[byte(s[0])]=' ' do dec(byte(s[0]));
      if (s<>'') and (pos('=', s)<>0) then begin
        inc(FileColCnt);
        with FileCol[FileColCnt] do begin
          Typ:=GrossStr(copy(s, 1, pos('=', s)-1));
          delete(s, 1, pos('=', s));
          val(s, Color, err);
          if err<>0 then begin
            Color:=$07;
            {$IFDEF debug}
            writeln('DOSuX: LoadColors: wrong color for "', Typ, '"-Files');
            {$ENDIF}
          end;
        end;
      end;
    end;
    close(f);
  end;
end;


function Color;
var
  i             : byte;
  col           : byte;
  p             : byte;
begin
  col:=$07;
  if (name<>'.') and (name<>'..') and (pos('.', name)=0) then name:=name+'.';
  for i:=1 to FileColCnt do with FileCol[i] do begin
    p:=pos('.'+Typ, name);
    if ((p=length(name)-length(typ)) and (p>0)) or (isadir and (Typ='/')) then col:=Color;
  end;
  Color:=col;
end;

function WriteName;
begin
  TextAttr:=Color(name, isadir);
  if isadir then name:=name+'/' else
  if (pos(name, '.EXE')>1) or (pos(name, '.COM')>1) or (pos(name, '.BAT')>1)
    then name:=name+'*';
  Dos2LinFn(name);
  write(name:align);
  TextAttr:=$07;
  writeName:=name;
end;


type
  { Verkettete Liste von Dateinamen }
  pFileName     = ^tFileName;
  tFileName     = record
    name        : string[8+1+3];
    Time        : longint;
    Size        : longint;
    attr        : word;
    farbe       : byte;
    next        : pFileName;
  end;
  tSortType     = (soGarNicht, soName, soTyp, soZeit, soGroesse);
  tShowType     = (shColumn, shRow, shCommas, shLong, shSingleC);


var
  Files         : pFileName;
  rekurs        : boolean;
  ShowHidden    : boolean;
  Show          : boolean;
  ShowRoot      : boolean;
  FileMask      : string;
  SortT         : tSortType;
  SortRevers    : boolean;
  ShowT         : tShowType;


procedure ShowHelp;
begin
  writeln('ls fr DOSuX');
  writeln;
  writeln('ls - listet (wie in Linux) die Dateien in einem Verzeichnis auf');
  writeln('Aktuell implementierte Parameter:');
  writeln;
  writeln('  -h, --help  Gibt diesen Hilfebildschirm aus');
  writeln;
  Show:=false;
end;

procedure ParseParam(var p : string);
  procedure Ersatz(lang, kurz : string);
  begin
    if pos('-'+lang, p)=1 then begin
      delete(p, 1, length(lang)+1);
      p:=kurz+p;
    end;
  end;

begin
  Ersatz('all', 'a');
  Ersatz('directory', 'd');
  Ersatz('help', 'h');
  Ersatz('format=long', 'l'); Ersatz('format=verbose', 'l');
  Ersatz('format=commas', 'm');
  Ersatz('reverse', 'r');
  Ersatz('sort=time', 't');
  Ersatz('format=across', 'x'); Ersatz('format=horizontal', 'x');
  Ersatz('almost-all', 'A');
  Ersatz('format=vertical', 'C');
  Ersatz('recursive', 'R');
  Ersatz('sort=size', 'S');
  Ersatz('sort=none', 'U');
  Ersatz('sort=extention', 'X');
  Ersatz('format=single-column', '1');
  {$IFDEF debug}
  writeln('DOSuX: ls: debug-msg - parsing ', p[1]);
  {$ENDIF}
  case p[1] of
    'a' : begin ShowHidden:=true; ShowRoot:=true; end;
    'd' : rekurs:=false;
    'f' : SortT:=soGarNicht;
    'h' : ShowHelp;
    'l' : ShowT:=shLong;
    'm' : ShowT:=shCommas;
    'r' : SortRevers:=true;
    't' : SortT:=soZeit;
    'x' : ShowT:=shRow;
    'A' : ShowHidden:=true;
    'C' : ShowT:=shColumn;
    'R' : rekurs:=true;
    'S' : SortT:=soGroesse;
    'U' : SortT:=soGarNicht;
    'X' : SortT:=soTyp;
    '1' : ShowT:=shSingleC;
    else begin
      writeln('DOSuX: ls: unknown parameter: ', p[1]);
      Show:=false;
    end;
  end;
  delete(p, 1, 1);
end;

type
  String12 = string[8+1+3];

procedure AddFile(var root : pFileName; filename : string12; attr : word; time, size : longint);
begin
  if root<>NIL then AddFile(root^.next, filename, attr, time, size) else begin
    new(root);
    root^.name:=filename;
    root^.attr:=attr;
    root^.time:=time;
    root^.size:=size;
    root^.next:=NIL;
  end;
end;


procedure FindFiles;
var
  s             : SearchRec;
begin
  FindFirst(FileMask, AnyFile, s);
  while DOSerror=0 do begin
    AddFile(Files, s.name, s.attr, s.time, s.size);
    FindNext(s);
  end;
end;


procedure DeleteFiles(var root : pFileName);
begin
  if root<>NIL then begin
    DeleteFiles(root^.next);
    dispose(root);
    root:=nil;
  end;
end;

procedure ShowFiles;
  procedure Ausgeben(p : tFileName);
  var
    name        : string;
    isdir       : boolean;
  begin
    name:=p.Name;
    isdir:=(p.attr and Directory<>0);
    case ShowT of
      shCommas : begin
        writeName(name, 14, isdir);
        write(', ');
      end;
      shLong   : begin
        writeName(name, 14, isdir);
        writeln(p.size:10);
      end;
      shColumn : begin
        writeName(name, 14, isdir);
        write('  ');
      end;
      else begin
        writeName(name, 0, isdir);
        writeln;
      end;
    end;
  end;
var
  p             : pFileName;
begin
  p:=Files;
  while p<>NIL do begin
    Ausgeben(p^);
    p:=p^.next;
  end;
end;



procedure ls(cmdline : string);
begin
  Files:=NIL;
  FileMask:='*.*';
  Show:=true;
  ShowHidden:=false;
  ShowRoot:=false;
  ShowT:=shColumn;

  SortRevers:=false;
  SortT:=soName;
  rekurs:=false;

  delete(cmdline, 1, 2); { 'ls' soll weg }
  while (cmdline<>'') and (cmdline<>' ') do begin
    if pos(' -', cmdline)=1 then begin
      delete(cmdline, 1, 2);
      while (cmdline[1]<>' ') and (cmdline<>'') do ParseParam(cmdline);
    end else begin
      while (cmdline[1]=' ') and (cmdline<>'') do delete(cmdline, 1, 1);
      FileMask:=copy(cmdline, 1, pos(' ', cmdline+' ')-1);
      {$IFDEF debug}
      writeln('DOSuX: ls: debug-msg - filemask set to ', FileMask);
      {$ENDIF}
      delete(cmdline, 1, pos(' ', cmdline+' '));
    end;
  end;
  if Show then begin
    FindFiles;
    {SortFiles;}
    ShowFiles;
    DeleteFiles(Files);
  end;
end;



end.